<?php
if (!defined('BASEPATH')) {
    die('Direct access to the script is not allowed');
}

// সফল লগআউট মেসেজ চেক করা
if (isset($_SESSION['logout_success'])) {
    $logout_message = $_SESSION['logout_success'];
    unset($_SESSION['logout_success']); // একবার দেখানোর পরে মুছে ফেলা
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Secure Admin Login</title>
    <link href="https://cdn.rentalpanelbd.com/cd7f76/main.649f08559dd1a6f53f02.css" rel="stylesheet">
    <!-- Font Awesome CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        /* Day/Night Mode */
        body.day-mode {
            background-color: #fff;
            color: #000;
        }
        body.night-mode {
            background-color: #2f2f2f;
            color: #fff;
        }

        /* Day/Night toggle button positioning */
        #dayNightToggle {
            position: fixed;
            top: 15px;
            right: 15px;
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
        }
    </style>
</head>
<body class="day-mode" id="body">

    <!-- Day/Night Mode Toggle -->
    <button type="button" onclick="toggleDayNightMode()" id="dayNightToggle">
        <i class="fas fa-sun"></i> <!-- Day icon (Sun) -->
    </button>

    <div class="container container-fluid" role="main">
        <div class="col-sm-offset-4 col-sm-6 col-md-offset-4 col-md-4 m-t">
            <form id="loginForm" action="admin" method="post">
                <div class="signin-form">

                    <!-- Success or Error Message -->
                    <?php if (isset($success)) : ?>
                        <div class="alert alert-success"><?= htmlspecialchars($successText, ENT_QUOTES, 'UTF-8') ?></div>
                    <?php elseif (isset($error)) : ?>
                        <div class="alert alert-danger"><?= htmlspecialchars($errorText, ENT_QUOTES, 'UTF-8') ?></div>
                    <?php endif; ?>
                    <?php if (isset($logout_message)): ?>
                        <div class="alert alert-success"><?= htmlspecialchars($logout_message, ENT_QUOTES, 'UTF-8') ?></div>
                    <?php endif; ?>

                    <!-- Username Field -->
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input id="username" class="form-control" type="text" name="username" required>
                    </div>

                    <!-- Password Field with Font Awesome Show/Hide Icon -->
                    <div class="form-group">
                        <label for="password">Password</label>
                        <div class="input-group">
                            <input id="password" class="form-control" type="password" name="password" required>
                            <span class="input-group-addon btn-primary" onclick="showPassword(this)">
                                <i class="fas fa-eye"></i> <!-- Font Awesome Eye Icon -->
                            </span>
                        </div>
                    </div>

                    <!-- Two-Factor Code Field -->
                    <div class="form-group">
                        <label for="two_factor_code">Two-Factor Code</label>
                        <input id="two_factor_code" class="form-control" type="number" name="two_factor_code" 
                               placeholder="Enter Code from Authenticator App (If Setup)">
                    </div>

                    <!-- reCAPTCHA -->
                    <?php if ($_SESSION["recaptcha"]) : ?>
                        <div class="form-group">
                            <div class="g-recaptcha" data-sitekey="<?= htmlspecialchars($settings["recaptcha_key"], ENT_QUOTES, 'UTF-8') ?>"></div>
                        </div>
                    <?php endif; ?>

                    <!-- CSRF Token -->
                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8') ?>">

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary btn-block">Log In to Admin Panel</button>

                </div>
            </form>
        </div>
    </div>

    <script>
        // Function to toggle password visibility
        function showPassword(icon) {
            var passwordField = document.getElementById('password');
            if (passwordField.type === "password") {
                passwordField.type = "text";
                icon.innerHTML = '<i class="fas fa-eye-slash"></i>';  // Font Awesome Eye Slash Icon
            } else {
                passwordField.type = "password";
                icon.innerHTML = '<i class="fas fa-eye"></i>';  // Font Awesome Eye Icon
            }
        }

        // Function to toggle Day/Night mode
        function toggleDayNightMode() {
            var body = document.getElementById('body');
            var toggleButton = document.getElementById('dayNightToggle');
            if (body.classList.contains('day-mode')) {
                body.classList.remove('day-mode');
                body.classList.add('night-mode');
                toggleButton.innerHTML = '<i class="fas fa-moon"></i>';  // Night icon (Moon)
            } else {
                body.classList.remove('night-mode');
                body.classList.add('day-mode');
                toggleButton.innerHTML = '<i class="fas fa-sun"></i>';  // Day icon (Sun)
            }
        }
    </script>
</body>
</html>